# StarXpand SDK for web マニュアル　V0.1.3
  
## 概要  
  
端末にUSB接続されたプリンターを、Webブラウザ上で動作するページから制御するライブラリ・SDK  
  
## 動作環境  

詳細は[README](./README_JP.md)をご参照ください。

### 対応OS・ブラウザ
  
| OS       | ブラウザ |  
| -------- | -------- |  
| Windows  | Chrome   |  
| Windows  | Edge     |  
| macOS    | Chrome   |  
| ChromeOS | Chrome   |  
| Ubuntu   | Chrome   |  
| Android  | Chrome   |  

Firefox、Safariは、2025年11月現在、WebUSB APIをサポートしていないため、非対応です。  
  
### 言語  
  
- TypeScript  
  
### 対応Interface  
  
- USB  

  Android AOA通信は非対応です。Printerクラスで接続してください。  
  TSP100IVシリーズ、TSP100IV SKシリーズを使用する場合は、USB-Cポートを使用してください。  
  
### 対応プリンター  
  
- mC-Print3シリーズ  
- mC-Print2シリーズ  
- mC-Label3シリーズ  
- mC-Label2シリーズ  
- mPOPシリーズ  
- TSP100IVシリーズ  
- TSP100IV-SKシリーズ  

## 配布方法  

[npm](https://www.npmjs.com/package/star-io10-web)で配信  
[github](https://github.com/star-micronics/star-io10-web)で公開  

## USBドライバの差し替えについて  

WindowsおよびUbuntuでは、以下の手順でUSBドライバを差し替える必要があります。

## Windowsの場合

1. プリンターの電源を入れ、プリンターとホストデバイスをUSBケーブルで接続します。  

  デバイスと通信可能なUSBポートはプリンターによって異なります。
  ご利用いただくプリンターのオンラインマニュアルまたはハードウェアマニュアルにてご確認ください。

2. プリンターのドライバを差し替えます。　　
  
  `example/scripts_for_client/Windows/install.bat` を、管理者権限で実行してください

  ドライバの差し替えを実行すると、他のソフトウェアからはUSBプリンターを使用できなくなります。
  プリンターを他のソフトウェアで使用する際は、以下の手順でドライバーを元に戻してください。

  1. デバイスマネージャーを開く
  2. 「ユニバーサル シリアル バス デバイス」から該当のプリンターを右クリックし、「ドライバーの更新」を選択する
  3. 「コンピューターを参照してドライバーを検索」を選択する
  4. 「コンピューター上の利用可能なドライバーの一覧から選択します」を選択する
  5. 「USB 印刷サポート」を選択し、「次へ」をクリックする

### Ubuntuの場合  

1. プリンターの電源を入れ、プリンターとホストデバイスをUSBケーブルで接続します。  

  デバイスと通信可能なUSBポートはプリンターによって異なります。
  ご利用いただくプリンターのオンラインマニュアルまたはハードウェアマニュアルにてご確認ください。

2. プリンターのドライバを差し替えます。  
  
  プリンターを使用する直前に、`example/scripts_for_client/linux/onetime.sh` を、管理者権限で実行してください
 
  プリンタードライバを差し替えると、従来のプリンタードライバは使用できなくなります。  
  以下の操作を行うと、スクリプトの効果は元に戻ります。従来のプリンタードライバを使用する際は、以下の操作を実行して下さい。  
  
  - プリンターのUSBケーブルを抜き差しする  
  - プリンターを再起動する  
  - Ubuntuを再起動する  

## 機能  
  
### StarXpandCommandBuilder  
  
  [react-native版](https://star-m.jp/products/s_print/sdk/react-native-star-io10/manual/ja/api-reference/star-xpand-command/index.html)と同様の機能を提供します。
  ただし、以下の点が異なります。  
  
#### 画像ソースの指定方法  

  [画像ソースの指定方法](https://star-m.jp/products/s_print/sdk/react-native-star-io10/manual/ja/api-reference/star-xpand-command/printer/image-parameter/constructor.html)が異なります  
  
  - 画像ソースの指定方法  
    - Base64エンコードされたコンテンツ  
    - リソースファイル名  

### StarDeviceDiscoveryManagerクラス  
  
  StarPrinterをopenする前に、`discover()`使用してプリンターへのアクセス権限を取得してください  
  
#### プロパティ  
  
- `onPrinterFound(printer: StarPrinter)`  
  検出されたプリンターを通知するデリゲート  
  
#### メソッド  
  
- `constructor(interfaceType: InterfaceType)`  
  
- `discover(options: DiscoverOptions): Promise<void>`  
  検索を実行する  
  実行すると、WebUSB APIが提供するポップアップが表示される  
  ポップアップから選択したプリンターへのアクセス権限が、WebUSB APIによって付与される  

> Memo:
  接続したプリンターがポップアップ内に表示されない場合、以下の方法でプリンターの設定を変更してください。  
  
  方法1 プリンター設定の変更  

  1. Star Quick Setup Utilityアプリで、プリンターに接続する  
  2. "デバイスの設定変更を行う" -> "USB設定" を開く  
  3. "USB-C機能" を "通信のみ" に設定する  
  4. "適用する" を押す  

  方法2 接続ケーブルの変更  

  1. ホストデバイスとプリンターを接続するUSBケーブルを、A-Cケーブルに変更する
   
### StarPrinterクラス  
  
#### プロパティ  
  
- `connectionSettings: StarConnectionSettings`  
  
#### メソッド  
  
- `constructor(connectionSettings: StarConnectionSettings)`  
　　印字可能になるまで、時間がかかる場合があります。  
　　StarPrinterFactoryクラスを使用すると、初期化処理の一部を事前に実行できます。  
  
- `async open(options: OpenOptions = new OpenOptions()): Promise<void>`  
  
- `async close(): Promise<void>`  
  
- `async print(options: PrintOptions = new PrintOptions()): Promise<void>`  
  
- `async printRawData(data: Uint8Array, options: PrintOptions = new PrintOptions()): Promise<void>`  
  
- `async getStatus(options: GetStatusOptions = new GetStatusOptions(),): Promise<StarPrinterStatus>`  
  
- `async getInformation(options: GetInformationOptions = new GetInformationOptions()): Promise<StarPrinterInformation>`  

### StarPrinterFactoryクラス
  
#### メソッド

- `constructor()`

- `createStarPrinter(connectionSettings: StarConnectionSettings): StarPrinter`  
  StarPrinterクラスのコンストラクタを使用すると、印字可能になるまで時間がかかる場合があります。  
  本メソッドを使用すると、印字可能になるまでの時間を短縮できます。
  
### Options.OpenOptionsクラス  
  
#### プロパティ  
  
- `timeout: number = 10_000`  
  接続時のタイムアウト時間を指定する  
  
### Options.PrintOptionsクラス  
  
#### プロパティ  
  
- `timeout: number = 30_000`  
  印刷時のタイムアウト時間を指定する  
  
- `template: string? = null`  
  テンプレート印刷時に、テンプレートを格納する  
  
- `enableCheckStatus: boolean = true`  
  falseに設定した場合、プリンターがエラー状態(紙なし等)でもコマンドを送信する  
  
### Options.GetStatusOptionsクラス  
  
#### プロパティ  
  
- `timeout: number = 5_000`  
  PrinterStatus取得のタイムアウト時間を指定る  
  
### Options.GetInformationOptionsクラス  
  
#### プロパティ  
  
- `timeout: number = 5_000`  
  PrinterInformation取得処理のタイムアウト時間を指定する  
  
### StarConnectionSettingsクラス  
  
#### プロパティ  
  
- `interfaceType: InterfaceType = InterfaceType.Unknown`  
  
- `identifier: string = StarConnectionSettings.FIRST_FOUND_DEVICE;`  
  製品シリアルナンバーとUSBシリアルナンバーを使用できる  
  
- `StarConnectionSettings.FIRST_FOUND_DEVICE: string`  
  最初に見つかったデバイスを使用する際にidentifierに代入する定数  
  
### StarPrinterInformationクラス  
  
#### プロパティ  
  
- `model: StarPrinterModel`  
- `emulation: StarPrinterEmulation`  
- `detail: StarPrinterInformationDetail`   
  
### StarPrinterStatusクラス  
  
#### プロパティ  
  
- `hasError: boolean`  
- `coverOpen: boolean`  
- `drawerOpenCloseSignal: boolean`  
- `paperEmpty: boolean`  
- `paperNearEmpty: boolean`  
- `detail: StarPrinterStatusDetail`  
  
### StarIO10Loggerクラス  
  
コンソールにログを出力する  
  
#### メソッド  
  
- `start()`  
  ログ出力を開始する  
  
- `stop()`  
  ログ出力を停止する  
  
## Copyright  
  
Copyright 2025 Star Micronics Co., Ltd. All rights reserved.